/**********************************************************************/
/*                                                                    */
/* Project Name:  G128 - CRG - 4MHz PBE mode - CW50                   */
/* Last modified: 05/01/2011                                          */
/* By:            b01802                                              */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/* Description: Set the bus clock 4MHz in PBE mode                    */
/*                                                                    */
/*                                                                    */
/* Documentation: MC9S12GRMV1.pdf                                     */
/*                                                                    */
/*                                                                    */
/* This software is classified as Engineering Sample Software.        */
/*                                                                    */
/**********************************************************************/
/*                                                                    */
/* Services performed by FREESCALE in this matter are performed AS IS */
/* and without any warranty. CUSTOMER retains the final decision      */
/* relative to the total design and functionality of the end product. */ 
/* FREESCALE neither guarantees nor will be held liable by CUSTOMER   */
/* for the success of this project. FREESCALE DISCLAIMS ALL           */
/* WARRANTIES, EXPRESSED, IMPLIED OR STATUTORY INCLUDING, BUT NOT     */
/* LIMITED TO, IMPLIED WARRANTY OF MERCHANTABILITY OR  FITNESS FOR A  */
/* PARTICULAR PURPOSE ON ANY HARDWARE, SOFTWARE ORE ADVISE SUPPLIED   */
/* TO THE PROJECT BY FREESCALE, AND OR NAY PRODUCT RESULTING FROM     */
/* FREESCALE SERVICES . IN NO EVENT SHALL FREESCALE BE LIABLE FOR     */
/* INCIDENTAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF THIS AGREEMENT. */
/*                                                                    */
/* CUSTOMER agrees to hold FREESCALE harmless against any and all     */
/* claims demands or actions by anyone on account of any damage, or   */
/* injury, whether commercial, contractual, or tortuous, rising       */
/* directly or indirectly as a result of the advise or assistance     */
/* supplied CUSTOMER in connection with product, services or goods    */
/* supplied under this Agreement.                                     */
/*                                                                    */
/**********************************************************************/

#include <hidef.h>      /* common defines and macros */
#include "derivative.h"      /* derivative-specific definitions */



//==============================================================================
//Important formulas:

//if external oscillator is enabled (OSCE = 1)
//  fref = fosc / (REFDIV + 1)

//if external oscillator is disabled (OSCE = 0)
//  fref = fIRC1M

//  fvco = 2 * fref * (SYNDIV + 1)

//if PLL is locked (LOCK = 1)
//  fpll = fvco / (POSTDIV + 1)

//if PLL is not locked (LOCK = 0)
//  fpll = fvco / 4

//if PLL is selected (PLLSEL = 1)
//  fbus = fpll / 2
//==============================================================================



//==============================================================================
//Delay
//==============================================================================
void Delay(void)
{
  unsigned int i,j;    
  
  for(i=0; i<65500; i++)  
    for(j=0; j<100; j++) asm nop;        
}

//==============================================================================
//main
//==============================================================================
void main(void) {      
  
  ECLKCTL_NECLK = 0;  //enable ECLK output (bus clock is visible on pin PE4)
  
  //============================================================================
  //Default state after reset:
  
  //PLL Engaged Internal Mode (PEI)
  //Reference clock = internal RC oscillator 1MHz
  //Default settings:
  //REFDIV[3:0] = 0x0F;
  //REFFRQ[1:0] = 0x00;
  //SYNDIV[5:0] = 0x18;
  //VCOFRQ[1:0] = 0x01;
  //POSTDIV[4:0] = 0x03;
  //fvco = 50MHz
  //fpll = 12.5MHz
  //fbus = 6.25MHz
  
  Delay();    //delay in order to see default bus frequency on ECLK output
  
  //============================================================================
  //We want to set:
  //PLL Bypassed External Mode (PBE)
  
  //First of all, we have to set PEE mode and then we are allowed to switch 
  //into PBE mode
  
  //PLL Engaged External Mode (PEE)
  //Reference clock = external oscillator = 8MHz for example      
  //REFDIV[3:0] = 0x00;
  //REFFRQ[1:0] = 0x02;
  //SYNDIV[5:0] = 0x01;
  //VCOFRQ[1:0] = 0x00;
  //POSTDIV[4:0] = 0x00;
  //fvco = 32MHz
  //fpll = 32MHz
  //fbus = 16MHz  
  
    
  //To enter PBE mode from PEI (PEE) mode:
  //1. Make sure the PLL configuration is valid: Program the reference divider 
  //   (REFDIV[3:0] bits) to divide down Oscillator frequency if necessary.
  //2. Enable the external Oscillator (OSCE bit)
  //3. Wait for Oscillator to start up (UPOSC=1)
  //4. Select the Oscillator clock as Bus clock (PLLSEL=0)
  
    
  CPMUSYNR_SYNDIV = 0x01;
  CPMUSYNR_VCOFRQ = 0x00;
      
  CPMUREFDIV_REFDIV = 0x00;
  CPMUREFDIV_REFFRQ = 0x02;
  
  CPMUPOSTDIV = 0x00;   
  
  //writing into CPMUSYNR or CPMUREFDIV will unlock the PLL.
  //While PLL is unlocked fpll is fvco/4 to protect the system from high
  //core clock frequencies during the PLL stabilization time. 
  //if PLL is locked then fpll = fvco / (POSTDIV + 1)
  
  
  //if external oscillator is disabled (OSCE = 0) then fref = fIRC1M
  //if external oscillator is enabled (OSCE = 1) then fref = fosc / (REFDIV + 1)
  
  
  
  CPMUOSC_OSCE = 1; //enable external oscillator OSCE
    
  
  //Wait for the UPOSC bit to set, indicating the oscillator 
  //starting up - the oscillator is qualified by the PLL
  while(CPMUFLG_UPOSC == 0);      

  //Set the PLLSEL to 0. System clocks are derived from OSCCLK now. 
  //fbus = fosc / 2
  CPMUCLKS_PLLSEL = 0;    

  
  //Since the adaptive spike filter uses VCOCLK (from PLL) to continuously qualify 
  //the external oscillator clock, losing PLL lock status (LOCK=0) means losing 
  //the oscillator status information as well (UPOSC=0).
  //The impact of losing the oscillator status in PBE mode is as follows:
  //The MSCAN module, which can be configured to run on the oscillator clock, 
  //may need to be reconfigured.
  //PLLSEL is set automatically and the Bus clock is switched back to the PLL clock.
  //Application software needs to be prepared to deal with the impact of losing 
  //the oscillator status at any time.  
    
  for(;;) {      
  
  } /* wait forever */
  /* please make sure that you never leave this function */
}